(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7702,        219]*)
(*NotebookOutlinePosition[      8470,        246]*)
(*  CellTagsIndexPosition[      8426,        242]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsection"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Calcula los puntos de intersecci\[OAcute]n de la recta de ecuaci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x + \ \((1/2 - t)\) y = 0\)\)]],
  " con la circunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 5\)]],
  ". Naturalmente, la soluci\[OAcute]n que obtengas depender\[AAcute] del par\
\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". \n",
  StyleBox["c) ",
    FontWeight->"Bold"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica en la que para valores de ",
  StyleBox["t",
    FontSlant->"Italic"],
  " de -10 a 10 con incrementos de 1, se vean la circunferencia y la recta \
del apartado ",
  StyleBox["a) ",
    FontWeight->"Bold"],
  "junto con los puntos de",
  StyleBox[" ",
    FontWeight->"Bold"],
  " intersecci\[OAcute]n de ambas. Representa los puntos en color rojo y con \
tama\[NTilde]o apropiado. Sugerencia: usa Plot con Epilog."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsection"],

Cell[BoxData[{
    \(sol = Solve[{x + \((1/2\  - \ t)\) y == 0, x^2 + y^2 == 5}, {x, y}]\), 
    \(puntos = {x, y} /. sol\)}], "Input"],

Cell[BoxData[
    \(\(Do[
      Plot[\(-x\)\/\(1/2\  - t\), {x, \(-4\), 4}, PlotRange -> {\(-4\), 4}, 
        PlotStyle -> Hue[ .12], 
        Epilog -> {Hue[ .6], Circle[{0, 0}, Sqrt[5]], Hue[0], 
            PointSize[ .02], Map[Point, puntos]}, AspectRatio -> Automatic], {
        t, \(-10\), 10, 1}]; \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Los n\[UAcute]meros de Fibonacci son los elementos de la sucesi\[OAcute]n \
1,1,2,3,5,8,13,21,34,... cuyos primeros dos elementos son iguales a 1 y cada \
elemento posterior es la suma de los dos que le preceden. Define una funci\
\[OAcute]n que calcule el n-\[EAcute]simo n\[UAcute]mero de Fibonacci F[n]. \
Comprueba tu soluci\[OAcute]n calculando los primeros 10 n\[UAcute]meros de \
Fibonacci.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Utiliza ListPlot[ ] para representar los n\[UAcute]meros de Fibonacci \
desde F[200] hasta F[250]. Repres\[EAcute]ntalos en rojo con un \
tama\[NTilde]o apropiado."
}], "Text"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Hay muchas formas de definir esta famosa sucesi\[OAcute]n (que est\
\[AAcute] implementada en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Aqu\[IAcute] puedes ver algunas."
}], "Text"],

Cell[BoxData[{
    \(Off[General::"\<spell1\>"]\), 
    \(fibo1[n_]\  := \n\t
      Module[{fn1 = 1, \ fn2 = 0}, \n\t\t
        Do[\ {fn1, \ fn2}\  = \ {fn1\  + \ fn2, \ fn1}, \ {n - 1}\ ]; \n\t\t
        fn1\n\t]\), 
    \(Table[fibo1[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo1[k], {k, 1, 1000}]; ]\)}], "Input"],

Cell[BoxData[{
    \(fibo2[n_] := 
      Module[{fib1 = 0, fib2 = 0, fib3 = 1, m}, \n\t\t
        For[m = 1, m < n, \(m++\), \n\t\t\t\t\tfib1 = fib2; \n\t\t\t\t\t
          fib2 = fib3; \n\t\t\t\t\tfib3 = fib1 + fib2; \n\t\t]; \n\t\tfib3]; 
    \nTable[fibo2[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo2[k], {k, 1, 1000}]; ]\)}], "Input"],

Cell[BoxData[{
    \( (*\ C\[OAcute]digo\ de\ Irene\ Fern\[AAcute]ndez\ y\ otros\ *) \n
    fibo4[x_] := \ 
      Module[{fib1\  = \ 1, fib2\  = \ 0, \ i}, 
        \[IndentingNewLine]For[i\  = \ 1, i\  < x, \ \(i++\); \ 
          fib1 = \ fib1\  + \ fib2; \ fib2\  = \ fib1 - fib2]; 
        \[IndentingNewLine]fib1\[IndentingNewLine]]; \n
    Table[fibo4[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo4[k], {k, 1, 1000}]; ]\)}], "Input"],

Cell[BoxData[{
    \( (*\ C\[OAcute]digo\ de\ Luca\ Conesa\ *) 
      \[IndentingNewLine]fibo3[x_]\  := \ 
      Module[{aux, m}, \[IndentingNewLine]aux\  = \ Table[1, {m, 0, x}]; 
        \  (*para\ generar\ aux\ como\ una\ lista\ *) \[IndentingNewLine]For[
          m = 3, m \[LessEqual] x, 
          aux[\([m]\)] = aux[\([m - 1]\)] + aux[\([m - 2]\)]; \(m++\)]; 
        \[IndentingNewLine]aux[\([x]\)]]; \nTable[fibo3[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo3[k], {k, 1, 1000}]; ]\)}], "Input"],

Cell["\<\
Lo que no se debe hacer es recursi\[OAcute]n porque es demasiado \
lenta.\
\>", "Text"],

Cell[BoxData[{
    \(fibo5[1] = \(fibo5[2] = 1\); \n
    fibo5[n_] := fibo5[n - 1] + fibo5[n - 2]\), 
    \(Table[fibo5[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo5[k], {k, 1, 30}]; ] (*\ 
      tarda\ much\[IAcute]simo\ en\ calcular\ los\ primeros\ 30\ 
        n\[UAcute]meros\ *) \)}], "Input"],

Cell[TextData[{
  "Hay una forma de mejorar la velocidad de ejecuci\[OAcute]n de la recursi\
\[OAcute]n a costa de cargar la memoria. El problema de la recursi\[OAcute]n \
es que cada n\[UAcute]mero debe generarse desde el principio y eso da lugar a \
que se hagan muchas llamadas a la funci\[OAcute]n. Para evitarlo podemos \
pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que recuerde los n\[UAcute]meros conforme los vaya calculando. Observa la \
peque\[NTilde]a, pero importante, diferencia."
}], "Text"],

Cell[BoxData[{
    \(fibo6[1] = \(fibo6[2] = 1\); \n
    fibo6[n_] := \(fibo6[n] = fibo6[n - 1] + fibo6[n - 2]\)\), 
    \(Table[fibo6[k], {k, 1, 10}]\), 
    \(Timing[Table[fibo6[k], {k, 1, 1000}]; ]\)}], "Input"],

Cell["\<\
Parece que este m\[EAcute]todo es el m\[AAcute]s r\[AAcute]pido. El \
problema es que ahora, a diferencia de antes, tenemos almacenado en memoria \
todos los valores calculados. Si tienes suficiente memoria para los \
c\[AAcute]lculos que vas a hacer, esto no importa demasiado.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[Table[fibo6[k], {k, 200, 250}], 
      PlotStyle -> {Hue[0], PointSize[ .015]}]; \)\)], "Input"],

Cell[TextData[
"Para ver todos los valores almacenados y la definici\[OAcute]n de la funci\
\[OAcute]n ejecuta el siguiente comando."], "Text"],

Cell[BoxData[
    \(\(?fibo6\)\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{978, 611},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 33, 0, 56, "Subsection"],
Cell[1767, 53, 975, 29, 111, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2779, 87, 38, 0, 56, "Subsection"],
Cell[2820, 89, 135, 2, 81, "Input"],
Cell[2958, 93, 322, 6, 141, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3317, 104, 33, 0, 56, "Subsection"],
Cell[3353, 106, 686, 14, 110, "Text"],
Cell[4042, 122, 262, 8, 34, "Text"],
Cell[4307, 132, 315, 7, 207, "Input"],
Cell[4625, 141, 338, 6, 228, "Input"],
Cell[4966, 149, 437, 8, 186, "Input"],
Cell[5406, 159, 503, 8, 186, "Input"],
Cell[5912, 169, 97, 3, 33, "Text"],
Cell[6012, 174, 297, 6, 123, "Input"],
Cell[6312, 182, 530, 10, 75, "Text"],
Cell[6845, 194, 214, 4, 123, "Input"],
Cell[7062, 200, 302, 5, 54, "Text"],
Cell[7367, 207, 127, 2, 60, "Input"],
Cell[7497, 211, 143, 2, 33, "Text"],
Cell[7643, 215, 43, 1, 60, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

